# Voter Creation Test Guide

## Fixed Issues
✅ **Issue**: `ration_card_number` field was being saved to voters table but the field doesn't exist
✅ **Solution**: Removed `ration_card_number` from voter data and only store `ration_card_id` (foreign key)

## How the System Now Works

### Case 1: Create Voter WITH Ration Card
If you provide `ration_card_number` in the request:
1. System finds the ration card by number in `ration_cards` table
2. Gets the ration card `id` 
3. Saves `ration_card_id` in voter record (establishes relationship)
4. Ration card number is accessible via the relationship

### Case 2: Create Voter WITHOUT Ration Card  
If you don't provide `ration_card_number` (or it's null):
1. `ration_card_id` is set to `null`
2. Voter is created as standalone (no ration card connection)

## Test Request Examples

### With Ration Card (Encrypted JSON):
```json
{
    "ration_card_number": "RC123456789",
    "voter_id_number": "ABC1234567890",
    "name": "John Doe",
    "gender": "Male",
    "year_of_birth": 1990,
    "booth_number": "001A",
    "mobile_number": "9876543210"
}
```

### Without Ration Card (Encrypted JSON):
```json
{
    "voter_id_number": "XYZ9876543210",
    "name": "Jane Smith", 
    "gender": "Female",
    "year_of_birth": 1995,
    "booth_number": "002B",
    "mobile_number": "9123456789"
}
```

## Database Structure
```
voters table:
- id (primary key)
- ration_card_id (foreign key, nullable) → links to ration_cards.id
- voter_id_number (unique)
- name
- gender
- year_of_birth
- ... other voter fields

ration_cards table:
- id (primary key) 
- ration_card_number (unique)
- address
- other_state
- ... other ration card fields
```

## API Endpoints
- `POST /api/voters/create` - Create individual voter
- `POST /api/voters/create-with-image` - Create voter with image upload
- `POST /api/voters/import` - Bulk import voters from CSV

## Expected Behavior After Fix
✅ Voters with valid ration card numbers → `ration_card_id` populated
✅ Voters without ration card numbers → `ration_card_id` = null  
✅ No more "column not found" errors
✅ Ration card number accessible via voter.rationCard.ration_card_number relationship