<?php

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';

$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Jobs\ProcessVoterImageBatch;
use Illuminate\Support\Facades\Log;

$directory = __DIR__ . '/Output';

echo "Starting import test for directory: $directory\n";

try {
    // Enable crop-based OCR with grid parameters
    $options = [
        'use_crops' => true,
        'reset_booth_voters' => true,
        'crop_options' => [
            'cols' => 3,
            'rows' => 10,
            'x_offset' => 0,
            'y_offset' => 75,   // Skip header, start at first voter card
            'bottom_offset' => 100, // Reserve space for footer but not too much
            'pad_x' => 0,       // No horizontal padding
            'pad_y' => 6,       // Default vertical padding
            // Row 10: reduce padding and carefully extend to capture voter IDs without footer
            'row_pad_y' => [10 => 2],
            // Extend row 10 slightly to capture voter IDs, but stay clear of footer (~50-60px should work)
            'row_extend_bottom' => [10 => 50],
        ]
    ];
    
    // Process ALL voter files (set maxImages to null to process all files)
    $job = new ProcessVoterImageBatch($directory, 0, null, $options);
    $job->handle();
    
    // Show summary
    $totalVoters = \App\Models\Voter::count();
    echo "Job executed successfully.\n";
    echo "Total voters imported: $totalVoters\n";
} catch (\Exception $e) {
    echo "Error executing job: " . $e->getMessage() . "\n";
    echo $e->getTraceAsString() . "\n";
}
