<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <style>
        @font-face {
            font-family: 'Noto Sans Tamil';
            src: url('data:font/truetype;base64,{{ base64_encode(file_get_contents($fontPath)) }}') format('truetype');
        }
        
        body {
            margin: 0;
            padding: 0;
            font-family: 'Noto Sans Tamil', Arial, sans-serif;
        }
        
        .container {
            width: 1181px;
            height: 886px;
            position: relative;
            background-image: url('data:image/jpeg;base64,{{ base64_encode(file_get_contents($backgroundImage)) }}');
            background-size: cover;
            background-position: center;
        }
        
        .photo {
            position: absolute;
            right: 55px;
            top: 300px;
            width: 230px;
            height: 280px;
            border: 4px solid #d4af37;
            background-size: cover;
            background-position: center;
        }

        .qr-code {
            position: absolute;
            right: 60px;
            top: 30px;
            width: 150px;
            height: 150px;
            border: 3px solid #000;
            background: #fff;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 5px;
        }
        
        .ration-box {
            position: absolute;
            right: 55px;
            top: 586px;
            width: 212px;
            padding: 10px;
            background: rgba(255, 255, 255, 0.95);
            border: 3px solid #d4af37;
            text-align: center;
            font-size: 32px;
            font-weight: bold;
            color: #000;
        }
        
        .name-section {
            position: absolute;
            left: 225px;
            top: 296px;
            font-size: 32px;
            font-weight: bold;
            color: #0D6340;
            max-width: 600px;
            line-height: 1.4;
            word-wrap: break-word;
        }
        
        .address-section {
            position: absolute;
            left: 225px;
            top: 362px;
            font-size: 28px;
            font-weight: bold;
            color: #0D6340;
            max-width: 650px;
            line-height: 1.4;
            word-wrap: break-word;
        }
        
        .mobile-section {
            position: absolute;
            left: 225px;
            top: 548px;
            font-size: 30px;
            font-weight: bold;
            color: #0D6340;
        }
        
        .counts-section {
            position: absolute;
            left: 223px;
            top: 605px;
            font-size: 30px;
            font-weight: bold;
            color: #0D6340;
            white-space: nowrap;
        }

        .counts-section .value-slot {
            display: inline-block;
            width: 170px;
            text-align: left;
        }

        .counts-section .value-slot:nth-child(2) {
            width: 250px;
        }

        .counts-section .value-slot:nth-child(3) .value {
            background: rgba(255, 255, 255, 0.95);
            padding: 5px 8px 5px 8px;
            border: 2px solid #d4af37;
            display: inline-block;
            margin-left: -20px;
            font-size: 32px;
        }
        
        .member-section {
            position: absolute;
            left: 355px;
            top: 684px;
            font-size: 30px;
            font-weight: bold;
            color: #0D6340;
        }
        
        .label {
            display: none; /* labels are printed on background image */
            font-weight: normal;
            color: #8B0000;
        }
        
        .value {
            display: inline;
            font-weight: bold;
            color: inherit;
        }
    </style>
    <script>
        // Static alignment against printed labels on the background.
        // No dynamic layout needed; positions are defined in CSS above.
    </script>
</head>
<body>
    <div class="container">
        @if($photoPath)
            <div class="photo" style="background-image: url('data:image/jpeg;base64,{{ base64_encode(file_get_contents($photoPath)) }}');"></div>
        @endif

        <!-- QR code (top right) based on ration card number -->
        <div class="qr-code">
            <img src="https://api.qrserver.com/v1/create-qr-code/?size=160x160&data={{ urlencode($rationCardNumber) }}" alt="QR" width="150" height="150" />
        </div>
        
        <div class="ration-box">{{ $rationCardNumber }}</div>
        
        <!-- Name value (aligned to printed label) -->
        <div class="name-section">
            <span class="value">{{ $headName }}</span>
        </div>
        
        <!-- Address value (aligned to printed label) -->
        <div class="address-section">
            @php
                // Split address by comma, trim parts, and drop empties
                $addressParts = array_values(array_filter(array_map('trim', explode(',', $address)), function ($p) {
                    return $p !== '';
                }));
            @endphp
            <span class="value">
                @if(count($addressParts) > 0)
                    {{ $addressParts[0] }}@if(isset($addressParts[1])), {{ $addressParts[1] }}@endif
                    @foreach(array_slice($addressParts, 2) as $part)
                        <br>{{ $part }}
                    @endforeach
                @else
                    {{ $address }}
                @endif
            </span>
        </div>
        
        <!-- Mobile value (aligned to printed label) -->
        <div class="mobile-section">
            <span class="value">{{ $mobile }}</span>
        </div>
        
        <!-- Gender counts values (aligned to printed labels) -->
        <div class="counts-section">
            <span class="value-slot"><span class="value">{{ $maleCount }}</span></span>
            <span class="value-slot"><span class="value">{{ $femaleCount }}</span></span>
            <span class="value-slot"><span class="value">{{ $totalCount }}</span></span>
        </div>
        
        <!-- Member Unique Id value (aligned to printed label) -->
        <div class="member-section">
            <span class="value">{{ $memberUniqueId }}</span>
        </div>
    </div>
</body>
</html>
