#!/bin/bash

# Production Deployment Script
echo "🚀 Starting Production Deployment..."

# Switch to production environment
./env-manager.sh production

# Install production dependencies only
echo "📦 Installing production dependencies..."
composer install --no-dev --optimize-autoloader --no-interaction

# Run database migrations
echo "🗄️ Running database migrations..."
php artisan migrate --force

# Clear and optimize for production
echo "🧹 Optimizing for production..."
php artisan optimize:clear
php artisan config:cache
php artisan route:cache
php artisan view:cache

# Set proper permissions
echo "🔒 Setting production permissions..."
chmod -R 755 storage bootstrap/cache
chown -R www-data:www-data storage bootstrap/cache

# Generate application key if not exists
if ! grep -q "APP_KEY=base64:" .env; then
    echo "🔑 Generating application key..."
    php artisan key:generate --force
fi

echo "✅ Production deployment complete!"
echo "⚠️  Remember to:"
echo "   - Set up proper web server configuration"
echo "   - Configure SSL certificates"
echo "   - Set up monitoring and logging"
echo "   - Configure backup systems"