<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddWardHColumnsToBooths extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('booths', function (Blueprint $table) {
            if (!Schema::hasColumn('booths', 'ward_no')) {
                $table->string('ward_no')->nullable()->after('booth_address');
            }
            if (!Schema::hasColumn('booths', 'h1')) {
                $table->string('h1')->nullable()->after('ward_no');
            }
            if (!Schema::hasColumn('booths', 'h2')) {
                $table->string('h2')->nullable()->after('h1');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('booths', function (Blueprint $table) {
            if (Schema::hasColumn('booths', 'ward_no')) {
                $table->dropColumn('ward_no');
            }
            if (Schema::hasColumn('booths', 'h1')) {
                $table->dropColumn('h1');
            }
            if (Schema::hasColumn('booths', 'h2')) {
                $table->dropColumn('h2');
            }
        });
    }
}
