<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddCasteIdAndCategoryIdToVoters extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('voters', function (Blueprint $table) {
            if (!Schema::hasColumn('voters', 'caste_id')) {
                $table->unsignedBigInteger('caste_id')->nullable()->after('caste');
            }
            if (!Schema::hasColumn('voters', 'category_id')) {
                $table->unsignedBigInteger('category_id')->nullable()->after('category');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('voters', function (Blueprint $table) {
            if (Schema::hasColumn('voters', 'caste_id')) {
                $table->dropColumn('caste_id');
            }
            if (Schema::hasColumn('voters', 'category_id')) {
                $table->dropColumn('category_id');
            }
        });
    }
}
