<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('voters', function (Blueprint $table) {
            // Add unique constraint for serial_number + booth_id combination
            // This ensures no duplicate serial numbers within the same booth
            $table->unique(['serial_number', 'booth_id'], 'unique_serial_per_booth');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('voters', function (Blueprint $table) {
            $table->dropUnique('unique_serial_per_booth');
        });
    }
};