<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('voters', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('ration_card_id'); // foreign key
            $table->string('voter_id_number')->unique();
            $table->string('name');
            $table->enum('gender', ['male', 'female', 'other']);
            $table->year('year_of_birth');
            $table->boolean('is_head')->default(false);
            $table->string('booth_number')->nullable();
            $table->timestamps();

            // Foreign key constraint
            $table->foreign('ration_card_id')->references('id')->on('ration_cards')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('voters');
    }
};
