<?php

return [
    'development' => [
        'api_rate_limit' => env('API_RATE_LIMIT', 1000),
        'debug_mode' => env('API_DEBUG_MODE', true),
        // Allow local dev frontends (localhost and LAN IPs)
        'cors_origins' => [
            'http://localhost:3000',
            'http://localhost:8080',
            'http://localhost:5173',
            // Common Vite/React dev ports on LAN
            'http://192.168.1.101:4000',
            'http://192.168.1.101:5173',
            'http://192.168.1.101:3000',
            'http://192.168.1.101:8080',
        ],
        'allowed_ips' => ['*'], // Allow all IPs in development
        'cache_ttl' => 60, // 1 minute cache in development
    ],
    
    'staging' => [
        'api_rate_limit' => env('API_RATE_LIMIT', 500),
        'debug_mode' => env('API_DEBUG_MODE', true),
        'cors_origins' => ['https://ps25.risingiceberg.com'],
        'allowed_ips' => ['*'], // Or specific staging IPs
        'cache_ttl' => 300, // 5 minutes cache in staging
    ],
    
    'production' => [
        'api_rate_limit' => env('API_RATE_LIMIT', 100),
        'debug_mode' => env('API_DEBUG_MODE', false),
        'cors_origins' => ['https://risingiceberg.com'],
        'allowed_ips' => [], // Define specific production IPs if needed
        'cache_ttl' => 3600, // 1 hour cache in production
    ],
];