<?php

namespace App\Security;

use App\Constants\Constants;
use Illuminate\Http\Client\Request;
use Illuminate\Support\Facades\Log;

class DecryptUtils
{

    public static function decryptRequestData($encryptedData)
    {
        try {
            // Log the encrypted data for debugging
            Log::info('Encrypted data received:', ['data' => substr($encryptedData, 0, 100) . '...']);
            
            $decryptedData = AESUtils::decrypt($encryptedData, Constants::ENCRYPTION_KEY);
            
            // Log the decrypted data for debugging
            Log::info('Decrypted data:', ['data' => $decryptedData]);
            
            if ($decryptedData === false || $decryptedData === null) {
                Log::error('Decryption failed for data:', ['encrypted' => substr($encryptedData, 0, 50) . '...']);
                return null;
            }
            
            $jsonData = json_decode($decryptedData, true);
            
            if (json_last_error() !== JSON_ERROR_NONE) {
                Log::error('JSON decode error:', [
                    'error' => json_last_error_msg(),
                    'decrypted_data' => $decryptedData
                ]);
                return null;
            }
            
            return $jsonData;
            
        } catch (\Exception $e) {
            Log::error('Exception in decryptRequestData:', [
                'message' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);
            return null;
        }
    }
}
