<?php
namespace App\Repositories;

use App\Models\Gift;

class GiftRepository
{
    protected $gift;

    public function __construct(Gift $gift)
    {
        $this->gift = $gift;
    }

    // Create Gift
    public function createGift(array $data)
    {
        return $this->gift::create($data);
    }

    // Get Gift by ID
    public function getGiftById($id)
    {
        return $this->gift::where('id', $id)->where('is_deleted', false)->first();
    }

    // Get all active gifts
    public function getAllGifts()
    {
        return $this->gift::where('is_deleted', false)->get();
    }

    // Get all deleted gifts
    public function getAllDeletedGifts()
    {
        return $this->gift::where('is_deleted', true)->get();
    }

    // Update Gift by ID
    public function updateGiftById($id, array $data)
    {
        return $this->gift::where('id', $id)->update($data);
    }

    // Soft delete Gift by ID
    public function deleteGiftById($id)
    {
        return $this->gift::where('id', $id)->update(['is_deleted' => true]);
    }

    // Find Gift by ID
    public function findGiftById($id)
    {
        return $this->gift::where('id', $id)->where('is_deleted', false)->first();
    }

    // Get gifts distributed to a specific ration card
    public function getGiftsByRationCard($rationCardNumber)
    {
        return \App\Models\GiftedRationCard::with(['gift'])
            ->where('ration_card_number', $rationCardNumber)
            ->where('is_deleted', false)
            ->whereHas('gift', function ($query) {
                $query->where('is_deleted', false);
            })
            ->orderBy('created_at', 'desc')
            ->get();
    }
}
