<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SurveyVoter extends Model
{
    use HasFactory;

    protected $fillable = [
        'survey_id',
        'voter_id',
        'booth_id',
        'street_id',
        'rating',
    ];

    protected $casts = [
        'rating' => 'integer',
    ];

    /**
     * Get the survey this voter belongs to
     */
    public function survey()
    {
        return $this->belongsTo(Survey::class);
    }

    /**
     * Get the street this voter belongs to
     */
    public function street()
    {
        return $this->belongsTo(Street::class);
    }
}
